<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AvailableFor extends Model
{
    use HasFactory;

    protected $table = 'available_for';
    protected $primaryKey = 'available_for_id';
    public $timestamps = true;

    protected $fillable = [
        'profile_id',
        'service_type',
    ];

    protected $casts = [
        'service_type' => 'array', // Cast service_type to array for JSON handling
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    /**
     * Define the relationship with the CandidateProfile model.
     */
    public function candidateProfile()
    {
        return $this->belongsTo(CandidateProfile::class, 'profile_id', 'Profile_id');
    }
}
